// // // // // // // // // // // // // // // //
//
//	Enemy Territory - Welt.cc
//
//	erstellt 1.2.98 Andreas Warnke
//	geändert 3.5.98 von Andreas Warnke
//



// // // // // // // // // // // // // // // //
//
//	include:
//

#include "Karte.h"
#include "Objekt.h"
#include "Welt.h"
#include "AVLTree.h"



// // // // // // // // // // // // // // // //
//
//	Konstruktor:
//

typedef
	ElementList * ElementListPointer;

Welt :: Welt ( unsigned int MapSize )
	: Karte ( MapSize )
{
	//	Erstellen des Objektfeldes:
	int maxfield = Karte :: Width * Karte :: Height;
	if ( maxfield > 0 )
		ObjektFeld = new ElementList [ maxfield ] ;
	else
		ObjektFeld = NULL;
}; 



// // // // // // // // // // // // // // // //
//
//	Destruktor:
//

Welt :: ~Welt ()
{
	//	Objekte Löschen:
	ObjektListe . MakeEmpty ( true );
	
	//	Objektfeld löschen:
	if ( ObjektFeld != NULL )
	{
		delete [] ObjektFeld;
		ObjektFeld = NULL;
	};
};



// // // // // // // // // // // // // // // //
//
//	Insert:
//

bool Welt :: Insert ( Objekt * inObjekt )
{
	//	korrekte Parameter?
	if ( ObjektFeld == NULL )
		return false;
		
	//	Füge es in die Objektliste ein:
	bool ok = ObjektListe . Insert ( (Element*) inObjekt );

	//	Füge es in ObjektBaum ein:
	if ( ok )
	{
		ok = ObjektBaum . Insert ( (AVLNode*) inObjekt );
		if ( ! ok )
			//	Objekt nicht korrekt eingefügt.
			ObjektListe . Remove ( (Element*) inObjekt );
	}

	//	Füge OBjekt in ObjektFeld ein:
	if ( ok )
	{
		//	ObjektFeld existiert.
		int x = inObjekt -> XPos;
		int y = inObjekt -> YPos;
		if ( ( GetFieldType ( x, y) != FT_EndOfWorld ) && ( ObjektFeld != NULL ) )
			//	x und y sind gültige Werte.
			ok = ObjektFeld [ x + Karte :: Width * y ] . Insert ( (Element*) inObjekt );			
 		else
 			ok = false;
 		
		if ( ! ok )
		{
			//	Objekt nicht korrekt eingefügt.
			ObjektListe . Remove ( (Element*) inObjekt );
			ObjektBaum . Remove ( ( AVLNode*) inObjekt );
		};
	};	
		
	return ok;
};



// // // // // // // // // // // // // // // //
//
//	DeleteID:
//

Objekt * Welt :: DeleteID ( unsigned int inID, bool real_deletion )
{
	//	Suche Objekt in Objektliste:
	/*unsigned int i = ObjektListe . CountElements ();
	bool found = false;*/
	Objekt * Test; 
	/*while (( i > 0 ) && ( ! found ))
	{
		i--;
		Test = ((Objekt*) ( ObjektListe . GetElement ( i )));
		found = ( Test -> GetID () == inID );
	};*/
	Test = (Objekt*) ObjektBaum . Remove ( inID );
	
	/*if ( found )*/
	if ( Test != NULL )
	{
		//	Objekt gefunden.
		int x = Test -> XPos;
		int y = Test -> YPos;
		ObjektListe . Remove ( (Element*) Test );
		
		//	Suche Objekt in ObjektFeld:
		if (( GetFieldType ( x, y) != FT_EndOfWorld ) && ( ObjektFeld != NULL ))
		{
			//	x,y ist ein gültiges Feld, ObjektFeld existiert
			unsigned int pos = x + Karte :: Width * y;
			ObjektFeld [ pos ] . Remove ( (Element*) Test );
		};
		
		if ( real_deletion )
		{
			//	Lösche das Objekt:
			delete Test;
			return NULL;
		}
		else
			return Test;
	};
	return NULL;
};



// // // // // // // // // // // // // // // //
//
//	DeleteAtPos:
//

void Welt :: DeleteAtPos ( int inX, int inY )
{
	//	gültige Parameter?
	if ( GetFieldType ( inX, inY ) == FT_EndOfWorld )
		return;
		
	if ( ObjektFeld == NULL )
		return;
	
	ObjektFeld [ inX + Karte :: Width * inY ] . MakeEmpty ( true );
};



// // // // // // // // // // // // // // // //
//
//	FindObject:
//

Objekt * Welt :: FindObject ( unsigned int inID )
{
	//	Suche Objekt in Objektliste:
	/*int i = ObjektListe . CountElements();
	while ( i > 0 )
	{
		i--;
		Objekt * Test = ((Objekt*) ObjektListe . GetElement ( i ));
		if ( Test -> GetID () == inID )
			return Test;
	};
	return NULL;*/
	return (Objekt*) ObjektBaum . Find ( inID );
};



// // // // // // // // // // // // // // // //
//
//	CountObjects:
//

unsigned int Welt :: CountObjects ( int inX, int inY)
{
	if (( GetFieldType ( inX, inY) == FT_EndOfWorld ) || ( ObjektFeld == NULL ))
		return 0;
	else
	{
		//	x,y ist gültig, ObjektFeld existiert.
		return ObjektFeld [ inX + inY * Karte :: Width ] . CountElements();
	};
};



// // // // // // // // // // // // // // // //
//
//	GetObjects:
//

void Welt :: GetObjects (
	int inX,
	int inY,
	unsigned int & outTyp,
	unsigned int & outSpieler,
	unsigned int & outAnzahl,
	bool & outAllArmiesBusy )
{
	//	default-Werte:
	outTyp = Obj_NoObject;
	outSpieler = 0;
	outAnzahl = 0;
	int sAllArmiesBusy = 0;

	if (( GetFieldType ( inX, inY) != FT_EndOfWorld ) && ( ObjektFeld != NULL ))
	{
		//	x,y ist gültig, ObjektFeld existiert.
		unsigned int pos = inX + inY * Karte :: Width;
		
		//	ElementList für dieses Feld existiert:
		unsigned int i = ObjektFeld [ pos ] . CountElements();
		while ( i > 0 ) 
		{
			i--;
			Objekt * Test = (Objekt*) ( ObjektFeld [ pos ] . GetElement( i ) );
			if ( outAnzahl == 0 )
			{
				//	Dies ist das erste zu registrierende Objekt:
				outSpieler = Test -> BelongsTo;
				outTyp = ( Test -> Typ & Obj_TypeMask );
			}
			else
			{
				//	Dies ist ein weiteres zu registierendes Objekt:
				if ( outSpieler != Test -> BelongsTo )
					outSpieler = 0;	//	multiple Players.
				if ( outTyp != ( Test -> Typ & Obj_TypeMask ) )
					outTyp = Obj_Mixed;	//	mixed Objects.
			};
			if ( ( Test -> Typ & Obj_TypeMask ) == Obj_Figur )
				if ( ( Test -> Typ & Obj_BusyMask ) == 0 ) 
					sAllArmiesBusy = -1;
				else if ( sAllArmiesBusy == 0 )
					sAllArmiesBusy = 1;
			outAnzahl ++;
		};
	};
	outAllArmiesBusy = ( sAllArmiesBusy == 1 );
};



// // // // // // // // // // // // // // // //
//
//	GetSpielerID:
//	
//	Diese Funktion geht davon aus,
//	daß auf einem Feld die Figuren von
//	höchstens einem Spieler stehen.
//

unsigned int Welt :: GetSpielerID ( int inX, int inY )
{
	if ( ObjektFeld == NULL )
		return 0;
	if ( GetFieldType ( inX, inY ) == FT_EndOfWorld )
		return 0;
	ElementList & Liste = ObjektFeld [ inX + Karte :: Width * inY ];
	if ( Liste . CountElements () == 0 )
		return 0;
	Objekt* sObj = (Objekt*) ( Liste . GetElement(0) );
	return sObj -> BelongsTo;
};



// // // // // // // // // // // // // // // //
//
//	MoveObjectTo
//

bool Welt :: MoveObjectTo ( Objekt * inObjekt )
{
	if ( ObjektFeld == NULL )
  		return false; 
  	//	Move object and update ObjektFeld.
	ObjektFeld [ inObjekt -> XPos + Karte :: Width * inObjekt -> YPos ] . Remove ( (Element*) inObjekt );
	inObjekt -> XPos = inObjekt -> MoveToX;
	inObjekt -> YPos = inObjekt -> MoveToY;
	ObjektFeld [ inObjekt -> XPos + Karte :: Width * inObjekt -> YPos ] . Insert ( (Element*) inObjekt );
	return true;
};



//
//	Ende
//
// // // // // // // // // // // // // // // //